//
//  Globals.swift
//  Orbis
//
//  Created by KALSI on 6/23/17.
//  Copyright © 2017 KALSI. All rights reserved.
// Not Live

import UIKit
import Alamofire
import MapKit
import UserNotifications
import MessageUI
import IDZSwiftCommonCrypto
import CommonCrypto
import SwiftSocket
import Reachability





let appDelegate = UIApplication.shared.delegate as! AppDelegate
var statusTypeV = ""
var parameters = NSDictionary()
var viewObject = UIViewController()
//let  baseURL = "http://54.218.78.31:50/dev/api/index.php/"
let  baseURL = "http://54.218.78.31:50/api/index.php/"
//http://54.218.78.31:50/api/index.php/user/login_asm/?number=447900162308

let appConfigService = "\(baseURL)user/get_setting_lwd/"
let killSignalsService = "\(baseURL)user/check_signal/"
let userInfoService = "\(baseURL)user/profile_download/"

let triggerService = "http://54.218.78.31:50/api/index.php/signals/check_trigger/"

let version = "1.2"



class Globals: NSObject,ClassLocationDelegate, UNUserNotificationCenterDelegate, MFMessageComposeViewControllerDelegate {
var messageTypeV = ""
  
    
    struct properties {
        func shadow(view : UIView, placement : CGPoint, pathType: String, cornerRadius : CGFloat? = nil )  {
            view.layer.masksToBounds = false
            view.layer.shadowColor = UIColor.black.cgColor
            view.layer.shadowOpacity = 0.7
            view.layer.shadowOffset = CGSize(width: 0, height: 0)
            view.layer.shadowRadius = 3
            
            let frame = CGRect(x: placement.x, y: placement.y, width: view.frame.size.width, height: view.frame.size.height)
            if pathType == Constants.kRoundBezierPath{
                view.layer.shadowPath = UIBezierPath(roundedRect:frame, cornerRadius: cornerRadius!).cgPath
            }else if pathType == Constants.kRectangleBezierPath{
                view.layer.shadowPath = UIBezierPath(rect: frame).cgPath
            }
            
            view.layer.shouldRasterize = true
            view.layer.rasterizationScale = UIScreen.main.scale
        }
        
    }
    struct animations {
        func fadeIn(view : UIView, duration : Double? = nil) {
            if duration == nil{
                UIView.animate(withDuration: 0.3) {
                    view.alpha = 1;
                }
            }else{
                UIView.animate(withDuration: duration!) {
                    view.alpha = 1;
                }
            }
        }
        func fadeOut(view : UIView, duration : Double? = nil) {
            if duration == nil{
                UIView.animate(withDuration: 0.3) {
                    view.alpha = 0;
                }
            }else{
                UIView.animate(withDuration: duration!) {
                    view.alpha = 0;
                }
            }
        }
    }
    struct Services {
        
        
        func AlamofireGetService(serviceURL : String, completion : @escaping ( _ result : NSDictionary) -> (), failure : @escaping ( _ fail : AnyObject) -> ()) {
            
            
            print(serviceURL)
            Alamofire.request("\(serviceURL)", method: .get).responseJSON { (response) in
                print(response)
                
                if let JSON = response.result.value {
                    if let _ = JSON as? NSDictionary{
                        let result : NSDictionary = (JSON as? NSDictionary)!
                        completion(result)
                    }
                }else{
                    failure(response.result.value as AnyObject)
                }
            }
            
        }
        
        func AlamofireGet(method : String, parameters : NSDictionary? = nil, completion : @escaping ( _ result : NSDictionary) -> (), failure : @escaping ( _ fail : AnyObject) -> ()) {
            
            var fullUrl = String()
            
            var x = 0
            while x < (parameters?.count)! {
                if x == 0{
                    fullUrl = "\(baseURL)\(method)?\(parameters?.allKeys[x] as! String)=\(parameters?.allValues[x] as! String)"
                }else{
                    fullUrl.append("&\(parameters?.allKeys[x] as! String)=\(parameters?.allValues[x] as! String)")
                }
                x+=1
            }
            
            Alamofire.request("\(fullUrl)", method: .get).responseJSON { (response) in
                print(response)
                print(fullUrl)
             //   completion(result)

                if let JSON = response.result.value {
                    if let _ = JSON as? NSDictionary{
                        let result : NSDictionary = (JSON as? NSDictionary)!
                        completion(result)
                    }
                }else{
                    failure(response.result.value as AnyObject)
                }
            }
            
        }
        func AlamofirePost(_ method: String, parameters : NSDictionary, completion: @escaping (_ result : NSDictionary) -> ()) {
            Alamofire.request("\(baseURL)\(method)", method: .post ,parameters: parameters as? Parameters).responseJSON { response in
                print(response.result.value)

                
                if let JSON = response.result.value {
                    if let _ = JSON as? NSDictionary{
                        let result : NSDictionary = (JSON as? NSDictionary)!
                        completion(result)
                    }
                }else{
                    print("no data")
                }
            }
        }
        func AlamofireTriggerPost(_ method: String, parameters : NSDictionary, completion: @escaping (_ result : NSDictionary) -> ()) {
            Alamofire.request(triggerService, method: .post ,parameters: parameters as? Parameters).responseJSON { response in
                
                if let JSON = response.result.value {
                    if let _ = JSON as? NSDictionary{
                        let result : NSDictionary = (JSON as? NSDictionary)!
                        completion(result)
                    }
                }else{
                    print("no data")
                }
            }
        }
        
    }
    
    //OTHERS
    func addPrompt(message : String, view: UIViewController, completion: @escaping ()-> ()) {
        let controller = UIAlertController(title: "Orbis", message: message, preferredStyle: .alert)
        view.present(controller, animated: true) {
            Timer.scheduledTimer(withTimeInterval: 1.5, repeats: true, block: { (Timer) in
                controller.dismiss(animated: true, completion: {
                    completion()
                })
            })
        }
    }
    func isValidEmail(testStr:String) -> Bool{
        let emailRegEx = "[A-Z0-9a-z._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,}"
        let emailTest = NSPredicate(format:"SELF MATCHES %@", emailRegEx)
        return emailTest.evaluate(with: testStr)
    }
    func TextFieldWarning(textField : UITextField) {
        let str : NSAttributedString = NSAttributedString(string: textField.placeholder!, attributes: [NSForegroundColorAttributeName:UIColor.red]);
        textField.attributedPlaceholder = str
        textField.becomeFirstResponder()
    }
    
    //MARK :- SetData
   
    func bgLocation(_ location: CLLocationCoordinate2D){
        
        print("bgLocationcallleddd")
        let dict = NSKeyedUnarchiver.unarchiveObject(with: UserDefaults.standard.object(forKey: Constants.dUserInfo) as! Data) as! NSDictionary
        
        print("firstDateDetected\(appDelegate.postDateTime)")
        
        var number = ""
        if UserDefaults.standard.object(forKey: "userContact") != nil{
            number = UserDefaults.standard.object(forKey: "userContact") as! String
        }
        //        if appDelegate.postDateTime == ""{
        //            appDelegate.postDateTime = Date().toString(format: "ddMMyyhhmmss")
        //            print("firstDateDetected\(appDelegate.postDateTime)")
        //
        //        }
        //
        
        if (UserDefaults.standard.object(forKey: "postdatetime") == nil){
            UserDefaults.standard.set(Date().toString(format: "ddMMyyhhmmss"), forKey: "postdatetime")
            
        }
        let postDateTime = UserDefaults.standard.object(forKey: "postdatetime") as! String
        
//        DateTime,IMEI Number,mobile number,message type,Latitude,longitude,Position DateTime,Position Type,status content(text),interval,Speed,Checksum
        parameters = [
            "datetime":Date().toString(format: "ddMMyyhhmmss"),
            "imei":"",
            "number":number,
            "messageType":"PUD",
            "lat":"\(location.latitude)",
            "long":"\(location.longitude)",
            "posdatatime": postDateTime,
            "postype":"GPS",
            "status":statusTypeV,
            "interval":"",
            "speed":version,
            "ref_id":"\(dict.value(forKey: "ref") as! String)"
            
            //                "lat":"\(appDelegate.userLocation.latitude)",
            //                "long":"\(appDelegate.userLocation.longitude)",
        ]
        messageTypeV = "PUD"

 //       self.directSendToARC(signalData: parameters.generateString())
        
        var triggerParameters = NSDictionary()
        
        triggerParameters = [
            "datetime":Date().toString(format: "ddMMyyhhmmss"),
            "imei":"",
            "number":number,
            "messageType":"iOS",
            "lat":"\(location.latitude)",
            "long":"\(location.longitude)",
            "posdatatime":postDateTime,
            "postype":"GPS",
            "status":statusTypeV,
            "interval":"",
            "speed":version,
            "trigger_from":"PUD",
            "ref_id":"\(dict.value(forKey: "ref") as! String)"

        ]
        
        
        
        Globals.Services().AlamofireTriggerPost(triggerService, parameters: triggerParameters, completion: { (result) in
            print("triggeredResponse\(result)")
            
            UserDefaults.standard.set(Date().toString(format: "ddMMyyhhmmss"), forKey: "postdatetime")
            appDelegate.postDateTime = Date().toString(format: "ddMMyyhhmmss")
            
            //                appDelegate.isAmberTimer = false
            //                self.GenerateNotificationWithSignal(self.messageTypeV)
        })
        
        let reachability = Reachability()!
        
        do{
            try reachability.startNotifier()
        }catch{
            print("could not start reachability notifier")
        }
        reachability.whenReachable = { reachability in
            if reachability.connection == .wifi {
                print("Reachable via WiFi")
                
            } else {
                print("Reachable via Cellular")
            }
//        Globals.Services().AlamofirePost("user/new_location_update/", parameters: parameters, completion: { (result) in
            Globals.Services().AlamofirePost("user/location_update/", parameters: parameters, completion: { (result) in

            print(result)
            
            UserDefaults.standard.set(Date().toString(format: "ddMMyyhhmmss"), forKey: "postdatetime")
            appDelegate.postDateTime = Date().toString(format: "ddMMyyhhmmss")
            
            print("Location updated in background!")
        })
        }
        
    }
    func getLocation(_ location: CLLocationCoordinate2D){
        
        
        
        var interval = ""
        if appDelegate.interval == 0 {
            interval = ""
        }
        else{
            interval = "\(appDelegate.interval)"
        }
        
        var number = ""
        if UserDefaults.standard.object(forKey: "userContact") != nil{
            number = UserDefaults.standard.object(forKey: "userContact") as! String
        }
        
        let postDateTime = UserDefaults.standard.object(forKey: "postdatetime") as! String

        parameters = [
            "datetime":Date().toString(format: "ddMMyyhhmmss"),
            "imei":"",
            "number":number,
            "messageType":messageTypeV,
            "lat":"\(appDelegate.userLocation.latitude)",
            "long":"\(appDelegate.userLocation.longitude)",
            "posdatatime":postDateTime,
            "postype":"GPS",
            "status":statusTypeV,
            "interval":interval,
            "speed":version

        ]

        
   // self.directSendToARC(signalData: parameters.generateString())

    
        if messageTypeV ==  "STA"{
        Globals.Services().AlamofirePost("signals/", parameters: parameters, completion: { (result) in
            print(result)
            
            UserDefaults.standard.set(Date().toString(format: "ddMMyyhhmmss"), forKey: "postdatetime")
            appDelegate.postDateTime = Date().toString(format: "ddMMyyhhmmss")
            
            appDelegate.isAmberTimer = false
            self.GenerateNotificationWithSignal(self.messageTypeV)
        })}else{
        
       SignalWebService()
        }
         }
    
    func setDataWithoutLoc(){
        var interval = ""
        if appDelegate.interval == 0 {
            interval = ""
        }
        else{
            interval = "\(appDelegate.interval)"
        }
        
        var number = ""
        if UserDefaults.standard.object(forKey: "userContact") != nil{
            number = UserDefaults.standard.object(forKey: "userContact") as! String
        }
        
        let postDateTime = UserDefaults.standard.object(forKey: "postdatetime") as! String

        
        parameters = [
            "datetime":Date().toString(format: "ddMMyyhhmmss"),
            "imei":"",
            "number":number,
            "messageType":messageTypeV,
            "lat":"\(appDelegate.userLocation.latitude)",
            "long":"\(appDelegate.userLocation.longitude)",
            "posdatatime":postDateTime,
            "postype":"GPS",
            "status":statusTypeV,
            "interval":interval,
            "speed":version

        ]
        print(parameters)
        SignalWebService()

    }
    
    
    func SignalWebService()  {
        self.GenerateNotificationWithSignal(self.messageTypeV)

//        Globals.Services().AlamofireGet(method: "signals/new_signal/", parameters: parameters as NSDictionary, completion: { (result) in
        Globals.Services().AlamofireGet(method: "signals/", parameters: parameters as NSDictionary, completion: { (result) in

            print(result)
            appDelegate.isAmberTimer = false
                if self.messageTypeV == Constants.sRedAlertAlarm{
//                    guard let number = URL(string: "tel://01513432846") else { return }
//                    UIApplication.shared.open(number)
                }
        }) { (failure) in
            
            print(failure)
            if self.messageTypeV == Constants.sRedAlertAlarm{
//                guard let number = URL(string: "tel://01513432846") else { return }
//                UIApplication.shared.open(number)
            }else{
              //  self.createNotification(title: "Request failed", message: "Resend data or send a sms!", sound: true)
                if appDelegate.isForeground{
                    print("sms")
                    
                    
                    let md5Data = self.MD5(string:parameters.generateString())
                    
                    let md5Hex =  md5Data.map {String(format: "%02hhx", $0) }.joined()
                    
                    self.SMSMessaging(textmessage: "\(parameters.generateString()),\(md5Hex)")
                }
            }
        }
    }
    
    func GenerateNotificationWithSignal( _ signal : String) {
        var message = ""
        if signal == Constants.sRedAlertAlarm{
        message = "Red alert activated!"
        }else if signal == Constants.sRedAlertUserCancel{
            message = "Red alert deactivated!"
        }else if signal == Constants.sAmberStart{
            message = "Amber timer activated!"
        }else if signal == Constants.sAmberStop{
            message = "Amber timer deactivated!"
        }else if signal == Constants.sAmberExtended{
            message = "Amber timer extended!"
        }else if signal == Constants.sAmberExpiredAlarm{
            message = "Amber timer expired! Starting Red alert!"
        }else if signal == Constants.sPositionUpdate{
            message = "Position updated and sent to ARC"
        }else if signal == Constants.sStatus{
            message = "Status & message sent to ARC"
        }else if signal == Constants.sFallDetectAlarm{
            message = "Fall Detected!"
        }
        else if signal == Constants.sManDown{
            message = "Man Down!"
        }
        if message != ""{
            createNotification(title: "ARC", message: message)
        }
    }
    func SetLocationDelegate()  {
        appDelegate.delegate = self
    }
    func setSignalData(messageType : String, status : String? = nil) {
        
        if status == nil || status == ""{
            statusTypeV = ""
        }else{
            statusTypeV = status!
        }
        
        
        
        if CLLocationManager.locationServicesEnabled() {
            appDelegate.isAmberTimer = true

            appDelegate.backgroundAccess = true
            messageTypeV = messageType
            
//            appDelegate.delegate = self
//            appDelegate.startUpdatingLocation()
//            
            var interval = ""
            if appDelegate.interval == 0 {
                interval = ""
            }
            else{
                interval = "\(appDelegate.interval)"
            }
            
            var number = ""
            
            var postDateTime = ""
            if UserDefaults.standard.object(forKey: "userContact") != nil{
                number = UserDefaults.standard.object(forKey: "userContact") as! String
            }
            
            if (UserDefaults.standard.object(forKey: "postdatetime") == nil){
              UserDefaults.standard.set(Date().toString(format: "ddMMyyhhmmss"), forKey: "postdatetime")
                postDateTime = UserDefaults.standard.object(forKey: "postdatetime") as! String
                

                
            }else{
                 postDateTime = UserDefaults.standard.object(forKey: "postdatetime") as! String

            }
      
            
            parameters = [
                "datetime":Date().toString(format: "ddMMyyhhmmss"),
                "imei":"",
                "number":number,
                "messageType":messageTypeV,
                "lat":"\(appDelegate.userLocation.latitude)",
                "long":"\(appDelegate.userLocation.longitude)",
                "posdatatime":postDateTime,
                "postype":"GPS",
                "status":statusTypeV,
                "interval":interval,
                "speed":version

            ]
            print(parameters)
            
            print(parameters.generateString())
            
           
  //       self.directSendToARC(signalData: parameters.generateString())

            var triggerParameters = NSDictionary()

            triggerParameters = [
                "datetime":Date().toString(format: "ddMMyyhhmmss"),
                "imei":"",
                "number":number,
                "messageType":"iOS",
                "lat":"\(appDelegate.userLocation.latitude)",
                "long":"\(appDelegate.userLocation.longitude)",
                "posdatatime":postDateTime,
                "postype":"GPS",
                "status":statusTypeV,
                "interval":interval,
                "speed":version,
                "trigger_from":messageTypeV
            ]
            
            
            print(triggerParameters.generateStringTrigger())

            
                        Globals.Services().AlamofireTriggerPost(triggerService, parameters: triggerParameters, completion: { (result) in
                print("triggeredResponse\(result)")
                
                UserDefaults.standard.set(Date().toString(format: "ddMMyyhhmmss"), forKey: "postdatetime")
                appDelegate.postDateTime = Date().toString(format: "ddMMyyhhmmss")
                
//                appDelegate.isAmberTimer = false
//                self.GenerateNotificationWithSignal(self.messageTypeV)
            })
          
            
            if messageTypeV ==  "STA"{
            
//                Globals.Services().AlamofirePost("signals/new_signal/", parameters: parameters, completion: { (result) in

                Globals.Services().AlamofirePost("signals/", parameters: parameters, completion: { (result) in
                    print(result)
                    
                    UserDefaults.standard.set(Date().toString(format: "ddMMyyhhmmss"), forKey: "postdatetime")
                    appDelegate.postDateTime = Date().toString(format: "ddMMyyhhmmss")
                    
                    appDelegate.isAmberTimer = false
                    self.GenerateNotificationWithSignal(self.messageTypeV)
                })}else{
                
                SignalWebService()
            }

            
        } else {
            print("Location services are not enabled")
            self.setDataWithoutLoc()
        }
       
        
    }
    

    
    func SendSignalToARC (controllerObject : UIViewController, signalType : String, status : String? = nil) {
        
        if (!self.checkSignalsAuthorization()){
            self.createNotification(title: "Request failed", message: "Your data requests are restricted. Please contact HS2.", sound: true)
            
            return
        }
        
        let reachability = Reachability()!
        reachability.stopNotifier()
        do{
            try reachability.startNotifier()
        }catch{
            print("could not start reachability notifier")
        }
        reachability.whenReachable = { reachability in
            if reachability.connection == .wifi {
                print("Reachable via WiFi")
                
            } else {
                print("Reachable via Cellular")
            }
            
            
            
            print("here reachable")
            self.setSignalData(messageType: signalType, status: status)
            return
        }
        
        reachability.whenUnreachable = { _ in
            
            
            print("here not reachable")
            
            
            self.messageTypeV = signalType
            
            appDelegate.messagePopup = true
            self.createNotification(title: "Request failed", message: "Resend data or send a sms!")
            // if appDelegate.isForeground{
            print("sms")
            viewObject = controllerObject
            //  self.setDataWithoutLoc()
            
            var interval = ""
            if appDelegate.interval == 0 {
                interval = ""
            }
            else{
                interval = "\(appDelegate.interval)"
            }
            
            var number = ""
            if UserDefaults.standard.object(forKey: "userContact") != nil{
                number = UserDefaults.standard.object(forKey: "userContact") as! String
            }
            
            let postDateTime = UserDefaults.standard.object(forKey: "postdatetime") as! String
            
            
            
            parameters = [
                "datetime":Date().toString(format: "ddMMyyhhmmss"),
                "imei":"",
                "number":number,
                "messageType":signalType,
                "lat":"\(appDelegate.userLocation.latitude)",
                "long":"\(appDelegate.userLocation.longitude)",
                "posdatatime":postDateTime,
                "postype":"GPS",
                "status":status ?? "",
                "interval":interval,
                "speed":version
                
            ]
            print(parameters)
            
            print(parameters.generateString())
            let md5Data = self.MD5(string:parameters.generateString())
            
            let md5Hex =  md5Data.map {String(format: "%02hhx", $0) }.joined()
            
            self.SMSMessaging(textmessage: "\(parameters.generateString()),\(md5Hex)")
            //}
        }
    }
    
    func createNotification(title : String, message : String, sound : Bool? = false, identifier : String? = "demo", interval : Int? = 1) {
        let content = UNMutableNotificationContent()
        content.title = title
        content.body = message
        //if sound!{
            content.sound = UNNotificationSound.default()
       // }
        let trigger  =  UNTimeIntervalNotificationTrigger(timeInterval: TimeInterval(interval!), repeats: false)
        let request = UNNotificationRequest(identifier: identifier!, content: content, trigger: trigger)
        UNUserNotificationCenter.current().add(request, withCompletionHandler: { (error) in
            // Handle error
        })
    }
    
    //MARK:- Send SMS
    func SMSMessaging(textmessage : String) {
        if MFMessageComposeViewController.canSendText() == true {
            
            
            var recipients:[String] = ["447860047514"]
            if messageTypeV == Constants.sRedAlertAlarm{
            
                recipients = [AppConfiguration.sharedInstance.redAlertSMSNo]
            }else{
                recipients = ["447860047514"]

            }
            let messageController = MFMessageComposeViewController()
            messageController.messageComposeDelegate  = viewObject as? MFMessageComposeViewControllerDelegate
            messageController.recipients = recipients
            messageController.body = textmessage
            print(textmessage)
            viewObject.present(messageController, animated: true, completion: nil)
        } else {
            //handle text messaging not available
        }
    }
    func messageComposeViewController(_ controller: MFMessageComposeViewController, didFinishWith result: MessageComposeResult) {
        controller.dismiss(animated: true, completion: nil)

    }
    
    func call() {
//        guard let number = URL(string: "tel://*31#01513432852")
        guard let number = URL(string: "tel://01513432852")
 else {
                return }
        UIApplication.shared.open(number)
        print(number)
        
    }
    
    func anotherNo() {
//        guard let number = URL(string: "tel://*31#01513432846") else { return }
        guard let number = URL(string: "tel://01513432846") else { return }

        UIApplication.shared.open(number)

    }
    
    
    

    
    
    //MARK: TCP Socket


    func directSendToARC(signalData : String)  {
        
        return
        let md5Data = MD5(string:signalData)

        let md5Hex =  md5Data.map {String(format: "%02hhx", $0) }.joined()
        print("md5Hex: \(md5Hex)")
        print("signalData: \(signalData)")

        //MARK: TCP Socket
        print("AppConfigurationIP: \(AppConfiguration.sharedInstance.IPAddress) and AppConfigurationPort: \(AppConfiguration.sharedInstance.port)")

        let client = TCPClient(address: AppConfiguration.sharedInstance.IPAddress, port: Int32(AppConfiguration.sharedInstance.port))
        switch client.connect(timeout: 10) {
        case .success:
            print("\(signalData),\(md5Hex)")
            appendToTextField(string: "Connected to host \(client.address)")
            if let response = sendRequest(string: "\(signalData),\(md5Hex)", using: client) {
           // if let response = sendRequest(string: "Hello", using: client) {

            appendToTextField(string: "Response: \(response)")
            }
        case .failure(let error):
            
            print("your message type is here ..........................................\(messageTypeV)")
            if messageTypeV == "PUD"{
                print("failure hit here\(appDelegate.hitValue)")

                
                if appDelegate.hitValue < 3{
                    appDelegate.hitValue = appDelegate.hitValue + 1
                    
                    self.perform(#selector(bgLocation(_:)), with: appDelegate.locmanager.location?.coordinate, afterDelay: 10)
                    
                    
                    
                    
                }
                
            }
            
            
            appendToTextField(string: String(describing: error))
        }

        client.close()
        
    }



    
    private func readResponse(from client: TCPClient) -> String? {
        guard let response = client.read(1024*10)
            else {
                return nil }
        
        return String(bytes: response, encoding: .utf8)
    }
    
    private func appendToTextField(string: String) {
        print(string)
    }
    
    private func sendRequest(string: String, using client: TCPClient) -> String? {
        appendToTextField(string: "Sending data ... ")
        
        switch client.send(string: string) {
        case .success:
            print("signal sent")
          //  self.GenerateNotificationWithSignal(messageTypeV)
            return nil
        case .failure(let error):
            appendToTextField(string: String(describing: error))
            return nil
        }
    }

    
    
    
    func MD5(string: String) -> Data {
        let messageData = string.data(using:.utf8)!
        var digestData = Data(count: Int(CC_MD5_DIGEST_LENGTH))
        
        _ = digestData.withUnsafeMutableBytes {digestBytes in
            messageData.withUnsafeBytes {messageBytes in
                CC_MD5(messageBytes, CC_LONG(messageData.count), digestBytes)
            }
        }
        
        return digestData
    }
    
    //MARK: - Check Signals Authorization
    
    func checkSignalsAuthorization() -> Bool {
        
        return UserDefaults.standard.bool(forKey: "isSignalsAllowed")
    }
    
    //MARK: - Kill all timers
    func killTimers() {
        
       appDelegate.pudTimer.invalidate()
        appDelegate.scheduler.invalidate()
        appDelegate.movescheduler.invalidate()
        appDelegate.fallscheduler.invalidate()
    }

    
    //MARK: - Check Location Authorization

    func checkLocationAuthorization(selectedView : UIViewController) -> Bool{
        
        if CLLocationManager.locationServicesEnabled() {
            
            return true
        }else{
            
            let alert = UIAlertController(title: "Sorry!", message: "GPS access is restricted. In order to use tracking, please enable GPS in the Settigs app under Privacy, Location Services.", preferredStyle: UIAlertControllerStyle.alert)
            alert.addAction(UIAlertAction(title: "Go to Settings now", style: UIAlertActionStyle.default, handler: { (alert: UIAlertAction!) in
                
                
                UIApplication.shared.open(NSURL(string:UIApplicationOpenSettingsURLString)! as URL)
            }))
            
            selectedView.present(alert, animated: false, completion: {
                
            })
            
            return false
        }
        
    }

}
